<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ongkirmembers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained(
                table: 'users',
                indexName: 'member_user_id'
            )->onDelete('cascade');
            $table->foreignId('member_id')->constrained(
                table: 'members',
                indexName: 'ongkirmember_member_id'
            )->onDelete('cascade');
            $table->foreignId('ongkir_id')->constrained(
                table: 'ongkirs',
                indexName: 'member_ongkir_id'
            )->onDelete('cascade');
            $table->text('alamat');
            $table->enum('sts_alamat', ['Y', 'N']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ongkirmembers');
    }
};
